/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.GraphInstance;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpManager.AppletNotifyInterface;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.nhm.eui.NhmGraphDetailsDialog;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class GraphDataSeriesImpl
implements Serializable,
AppletNotifyInterface {
    String name;
    String instance;
    double holeValue;
    Date timeBase;
    Vector dates;
    Vector values;
    int numSamples;
    double totalValue;
    double minValue;
    Date minDate;
    double maxValue;
    Date maxDate;
    PollingObjectInstance poi;
    GraphInstance gi;
    NhmGraphDetailsDialog dialog;
    double selectedValue;
    Date selectedDate;
    int previousSelectedIndex;
    int selectedIndex;
    boolean pointIsSelected = false;
    boolean registeredForEvents;
    Date eventRegistrationDate;
    double selectedPercent;

    public GraphDataSeriesImpl(String string, String string2, PollingObjectInstance pollingObjectInstance, GraphInstance graphInstance, Date date, double d) {
        this.name = string;
        this.instance = string2;
        this.poi = pollingObjectInstance;
        this.gi = graphInstance;
        this.holeValue = d;
        this.timeBase = date;
        this.dates = new Vector();
        this.values = new Vector();
        this.registeredForEvents = false;
        try {
            UnicastRemoteObject.exportObject(this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized int addDataPoint(DataPoint dataPoint) {
        float f = 0.0f;
        double d = 0.0;
        int n = -1;
        long l = dataPoint.getDate() - this.timeBase.getTime();
        double d2 = l / 1000L;
        this.dates.addElement(new Double(d2));
        f = dataPoint.getValue();
        if (f != Float.NEGATIVE_INFINITY) {
            d = f;
            this.values.addElement(new Double(d));
            ++this.numSamples;
            this.totalValue += d;
            if (this.minDate == null || d < this.minValue) {
                this.minDate = new Date(dataPoint.getDate());
                this.minValue = d;
            }
            if (this.maxDate == null || d > this.maxValue) {
                this.maxDate = new Date(dataPoint.getDate());
                this.maxValue = d;
            }
        } else {
            this.values.addElement(new Double(this.holeValue));
        }
        if (this.dates.size() == this.values.size()) {
            n = this.dates.size() - 1;
        }
        return n;
    }

    public void setSelected(int n) {
        this.previousSelectedIndex = this.selectedIndex;
        this.selectedIndex = n;
        this.pointIsSelected = true;
    }

    public void showDetails(Frame frame, double d, Applet applet) {
        this.selectedPercent = d;
        if (this.dialog == null) {
            this.dialog = new NhmGraphDetailsDialog(frame, this, applet);
            this.dialog.show();
            return;
        }
        if (this.dialog.isShowing() && this.selectedIndex == this.previousSelectedIndex) {
            ((Component)this.dialog).setVisible(false);
            this.dialog = null;
            return;
        }
        this.dialog.setData(this);
        this.dialog.show();
    }

    public void removeDetails() {
        this.dialog.dispose();
        this.dialog = null;
    }

    public void registerForEvents(DpmClientApplet dpmClientApplet) {
    }

    public void unregisterForEvents(DpmClientApplet dpmClientApplet) {
    }

    public String getName() {
        String string = this.name;
        if (this.instance != null) {
            string = string.concat(".");
            string = string.concat(this.instance);
        }
        return string;
    }

    public synchronized Double getDate(int n) {
        Double d = null;
        try {
            d = (Double)this.dates.elementAt(n);
        }
        catch (Exception exception) {
            System.out.println("Can not get date at index " + n);
            System.out.println("Returning date of last point");
            d = (Double)this.dates.lastElement();
        }
        return d;
    }

    public synchronized Double getValue(int n) {
        Double d = null;
        try {
            d = (Double)this.values.elementAt(n);
        }
        catch (Exception exception) {
            System.out.println("Can not get value at index " + n);
            System.out.println("Returning value of last point");
            d = (Double)this.values.lastElement();
        }
        return d;
    }

    public synchronized Vector getDates() {
        return this.dates;
    }

    public synchronized Vector getValues() {
        return this.values;
    }

    public String getInstance() {
        return this.instance;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append("." + this.instance);
        }
        return stringBuffer.toString();
    }

    public void updateEvent(Vector vector) throws RemoteException {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PerformanceEvent performanceEvent = (PerformanceEvent)enumeration.nextElement();
            switch (performanceEvent.getCause()) {
                case 4: {
                    DataPoint dataPoint = (DataPoint)performanceEvent.getHistory().firstElement();
                    System.out.println("Got new data point for " + this.name + ": " + dataPoint);
                    n = this.addDataPoint(dataPoint);
                    if (n == -1) break;
                    this.gi.graphUpdateSeries(this, n);
                    break;
                }
            }
        }
    }

    public double getAverage() {
        double d = 0.0;
        if (this.numSamples > 0) {
            d = this.totalValue / (double)this.numSamples;
        }
        return d;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public synchronized Double getSelectedValue() {
        Double d = null;
        d = this.pointIsSelected ? this.getValue(this.selectedIndex) : this.getValue(this.values.size() - 1);
        return d;
    }

    public synchronized Double getSelectedDate() {
        Double d = null;
        d = this.pointIsSelected ? this.getDate(this.selectedIndex) : this.getDate(this.dates.size() - 1);
        return d;
    }

    public synchronized Date getLatestDateObject() {
        return this.getDateObject(this.numSamples - 1);
    }

    public synchronized Date getSelectedDateObject() {
        int n = this.dates.size() - 1;
        if (this.pointIsSelected) {
            n = this.selectedIndex;
        }
        return this.getDateObject(n);
    }

    public synchronized Date getDateObject(int n) {
        Date date = null;
        double d = this.getDate(n);
        long l = (long)(d * 1000.0);
        date = new Date(l + this.timeBase.getTime());
        return date;
    }

    public double getSelectedPercent() {
        return this.selectedPercent;
    }
}

